﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Spectral1.DATA_ACCESS
{
    public class c_waveset_data_changed
    {

        public bool changed_since_last_save_to_module = false;
        private bool _waveset_row;
        private bool[,,] _wh = new bool[DA_Spectral.max_note_sectors, DA_Spectral.max_intensity_layers, DA_Spectral.max_waveforms];

        #region "================= METHODS =============================="
        public void set_waveset_row(bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _waveset_row = set;
        }

        public bool get_waveset_row()
        {
            return _waveset_row;
        }

        public void set_wh(int note_sector_id, int intensity_layer_id,int waveform_id, bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _wh[note_sector_id, intensity_layer_id, waveform_id] = set;
        }

        public bool get_wh(int note_sector_id, int intensity_layer_id, int waveform_id)
        {
            return _wh[note_sector_id, intensity_layer_id, waveform_id];
        }

        public void set_waveform_harmonics_changed(Int32 note_sector_id, Int32 intensity_layer_id, Int32 waveform_id, bool value)
        {
            set_wh(note_sector_id, intensity_layer_id, waveform_id,value);
        }

        public bool get_waveform_harmonics_changed(Int32 note_sector_id, Int32 intensity_layer_id, Int32 waveform_id)
        {
            return get_wh(note_sector_id, intensity_layer_id, waveform_id);
        }

        public c_waveset_data_changed()
        {
            set_all(false);
        }
        public void set_all(bool b)
        {
            for (int s = 0; s < DA_Spectral.max_note_sectors; s++)
            {
                for (int l = 0; l < DA_Spectral.max_intensity_layers; l++)
                {
                    for (int w = 0; w < DA_Spectral.max_waveforms; w++)
                    {
                        set_wh(s, l, w,b);
                    }
                }
            }
            _waveset_row = b;
        }

        #endregion



    }
}
